/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
Subfile to clean wages and generate hourly and weekly wages.
5.7.2019 (revised 5.8.2020)
Pascual Restrepo
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

* recover year of survey *
sum year
local year=r(mean)

gen wkswork=0
replace wkswork=7 		if wkswork2==1 
replace wkswork=20 		if wkswork2==2 
replace wkswork=33 		if wkswork2==3 
replace wkswork=43.5 	if wkswork2==4 
replace wkswork=48.5 	if wkswork2==5 
replace wkswork=51 		if wkswork2==6 

if `year'>=1980{
gen hrswork=uhrswork
}
else if `year'<=1970{
gen hrswork=.
replace hrswork=7.5  if hrswork2==1 
replace hrswork=22   if hrswork2==2 
replace hrswork=32   if hrswork2==3 
replace hrswork=37   if hrswork2==4 
replace hrswork=40   if hrswork2==5 
replace hrswork=44.5 if hrswork2==6 
replace hrswork=54   if hrswork2==7 
replace hrswork=70   if hrswork2==8 
}

* generate labor supply weights *
gen lswts=hrswork*wkswork*perwt

* sample of wage earners (wages gathered for people who had a job in last 12 months/last year---workedyr==3) *
gen earnsamp=(workedyr==3)
replace earnsamp=0 if (classwkrd>=10 & classwkrd<=14) | classwkrd==29 /*Removes self employed and unpaid family workers*/
replace earnsamp=0 if hrswork==0 
replace earnsamp=0 if wkswork==0
replace earnsamp=0 if incwage==0 | incwage==999999
replace incwage=. if earnsamp==0

*Top-coding: set to 1.5 times top code and convert to 2007 dollars *
*Convert to 2007 dollars using PCE from From BEA* 
*1979: 39.531   (for 1980 census) 
*1999: 81.110 	(for 2000 census)
*2007: 97.102 	reference year	
*2014: 109.157 	(for 2012-2016 ACS)
if `year'==1980{
*Note: this survey includes the years 1979, so we use the PCE in 1979*
replace incwage=1.5*75000 if incwage>=75000
gen real_income=incwage*(97.102/39.531)
gen MAXWG=(1.5*75000/(35*50))*(97.102/39.531)  /*Roughly 180 dollars per hour in 2007*/
}
else if `year'==2000{
*Note: this survey includes wages for 1999, so we use the PCE in 1999*
replace incwage=1.5*175000 if incwage>=175000
gen real_income=incwage*(97.102/81.110)
gen MAXWG=(1.5*175000/(35*50))*(97.102/81.110) /*Roughly 180 dollars in 2007*/
}
else if `year'==2016{
*Note: this survey includes the years 2012-2016, so we use the PCE in 2014*
replace incwage=1.5*210000 if incwage>=210000 
gen real_income=incwage*(97.102/109.157)
gen MAXWG=(1.5*210000/(35*50)) /*For all ACS years, winsorize at 180 dollars per hour*/
}

* winsorize real hourly wages at 2 dollars (2007 dollars) below and MAXWG above (roughly 180 dollars from 2007) *
gen 	hrwage=real_income/(hrswork*wkswork)
replace hrwage=MAXWG if hrwage>MAXWG & hrwage!=. 
replace hrwage=2 if hrwage<2 & hrwage!=.
replace hrwage=. if earnsamp==0

* weekly and yearly wages *
gen wkwage=hrwage*hrswork
gen yrwage=hrwage*hrswork*wkswork

